import sys
import logging
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path
logging.getLogger('suds.client').setLevel(logging.CRITICAL)

##from OSEHRAHelper import PROMPT
##from ConnectToVista import ConnectToVista
##from AddOneInstitution import AddOneInstitution
##from AddHCSDivision import AddHCSDivision
##from AddOneDivision import AddOneDivision, AddOneDivisionP
##from AddOneServiceSection import AddOneServiceSection
##from AddOneAppointmentType import AddOneAppointmentType
##from AddOneHoliday import AddOneHoliday
##from AddOneDoctor import AddOneDoctor
##from AddDoctors import GoToUserManagementMenu, GoToPrompt
##from ReplaceDatabase import ReplaceDatabase
from time import sleep
from suds.client import Client
import copy
import datetime

from pytz import timezone
from pytz import common_timezones
import pytz
import time
from ReplaceDatabase import ReplaceDatabase

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'GEORGIA'
state_short = 'GA'
domain = 'GA.VA.GOV'
facility1_site_id = '556'
facility2_abbr = 'GVARMC'
facility3_abbr = 'GVAOPC'
patient_ssn = '100000006'
patient2_ssn = '100000007'
patient3_ssn = '100000008'
patient4_ssn = '300000006'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase3Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase3/cache.dat")
sleep(60)

sleep(5)
print 'setp 1'
print '\treceive appointment request'
patients = client.service.SearchPatients(facility1_site_id,patient_ssn)
patient1 = client.service.GetPatient(patients[0])

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section1 = copy.deepcopy(p)
		break;

providers = client.service.GetAllProviders()
for p in providers.Provider:
	if p.Person.FirstName == 'PROVIDER' and p.Person.LastName == 'ONE':
		provider = copy.deepcopy(p)
		break;

resource = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource.Blocks = blocks
holds.Hold = []
resource.Holds = holds
schdPolicies.SchedulingPolicy = []
resource.Name = 'case 3 provider,one'
resource.Section = section1
resource.Type = 'Provider'
resource.FullfillingResourceId = provider.Id
result = client.service.AddResource(resource)
resource8_result = copy.deepcopy(result)

schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resource8_result.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)
resources = client.service.GetAllResources(section1.Id)

slots = client.factory.create('ns0:ArrayOfSlot')
slot = client.factory.create('ns0:Slot')
slot.Time = 'PT15H'
slot.Length = 30
slot.Capacity = 1
slot.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot)

slot2 = client.factory.create('ns0:Slot')
slot2.Time = 'PT15H30M'
slot2.Length = 30
slot2.Capacity = 1
slot2.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot2)

slot3 = client.factory.create('ns0:Slot')
slot3.Time = 'PT16H'
slot3.Length = 30
slot3.Capacity = 1
slot3.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot3)

slot4 = client.factory.create('ns0:Slot')
slot4.Time = 'PT16H30M'
slot4.Length = 30
slot4.Capacity = 1
slot4.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot4)

slot5 = client.factory.create('ns0:Slot')
slot5.Time = 'PT17H'
slot5.Length = 30
slot5.Capacity = 1
slot5.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot5)

slot6 = client.factory.create('ns0:Slot')
slot6.Time = 'PT17H30M'
slot6.Length = 30
slot6.Capacity = 1
slot6.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot6)

resource8_result.SchedulingPolicies.SchedulingPolicy[0].Slots = slots
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

for p in resources.Resource:
	if p.Name == 'case 2 step 8 provider,one':
		resource1 = copy.deepcopy(p)
		break;
		
appreq = client.factory.create('ns0:AppointmentRequest')

appreq.Patient = patient1
appreq.RequestMethod = 'Email'
appreq.RequestedResource  = resource1
appreq.Status = 'Unknown'
appreq.Reason = 'Unknown'
appreq.Time = datetime.datetime.strptime('2013-05-16 08:00:00', '%Y-%m-%d %H:%M:%S')
result = client.service.AddAppointmentRequest(appreq)
appreq1 = copy.deepcopy(result)

sleep(5)
print 'step 2'
print '\tenter desired future appointment date'
appreq1.DesiredDate = datetime.datetime.strptime('2013-07-08 08:00:00', '%Y-%m-%d %H:%M:%S')
appreq1.RequestedSection = section1
result = client.service.UpdateAppointmentRequest(appreq1)
appreq2 = copy.deepcopy(result)

sleep(5)
print 'step 3'
print '\tregister patient'
patients = client.service.SearchPatients(facility1_site_id,patient_ssn)
patient3 = client.service.GetPatient(patients[0])

sleep(5)
print 'step 4'
specialneeds = client.factory.create('ns0:ArrayOfSpecialNeed')
specialneed = client.factory.create('ns0:SpecialNeed')
result = client.service.GetSpecialNeedTypes()
for p in result.SpecialNeedType:
	if p.Name == 'Wheelchair access':
		specialneedtype = copy.deepcopy(p)
		break;
specialneed.SpecialNeedType = specialneedtype
specialneeds.SpecialNeed = specialneed
patient3.SpecialNeeds = specialneeds

patientpreferences = client.factory.create('ns0:ArrayOfPatientPreference')
patientpreference = client.factory.create('ns0:PatientPreference')
result = client.service.GetPatientPreferenceTypes()
for p in result.PatientPreferenceType:
	if p.Name == 'Use email':
		ppreftype = copy.deepcopy(p)
		break;
patientpreference.PatientPreferenceType = ppreftype
patientpreferences.PatientPreference = patientpreference
patient3.Preferences = patientpreferences

result = client.service.Update(patient3)
patient3 = copy.deepcopy(result)
print patient3

sleep(5)
print 'step 5'
print '\tcreate appointment for the patient on 23 july 2013 (22 july 2013 is va holiday)'
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource8_result
appointment.Patient = patient3
appointment.Length = 30
appointment.Section = resource8_result.Section
appTimeStamp = datetime.datetime(2013,07,23,19,00,00)
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource8_result.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment5 = copy.deepcopy(result)
    print appointment5.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'checkpoint 1'
if logdetail == 1:
	print appointment5
print '\tappointment is scheduled on agreed upon date'

sleep(5)
print 'step 9'
print '\tschedule appointments for the same patient and link two appointments'
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource8_result
appointment.Patient = patient3
appointment.Length = 30
appointment.Section = resource8_result.Section
appTimeStamp = datetime.datetime(2013,07,23,19,30,00)
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource8_result.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment9 = copy.deepcopy(result)
    print appointment9.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()
    
relation = client.factory.create('ns0:AppointmentRelation')
ARelation = client.factory.create('ns0:ArrayOfAppointmentRelation')
relation.ChildAppointment = appointment9
relation.RelationType='Followup'
ARelation.AppointmentRelation = relation
appointment5.ChildAppointments = ARelation

result = client.service.UpdateAppointment(appointment5)
appointment9 = copy.deepcopy(result)

comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient3.Id
comqueue.SendBy = datetime.datetime(2013,7,20)
comqueue.SentOn = datetime.datetime(2013,7,19)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment9

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 2'
if logdetail == 1:
	print appointment5
print '\ttwo appointments for the same patient'

print 'step 10'
print '\tpatient pre-appointment notification'
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient1.Id
comqueue.SendBy = datetime.datetime(2013,6,30)
comqueue.SentOn = datetime.datetime(2013,6,29)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment5

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 3'
if logdetail == 1:
	print comqueue_result
print '\tpatient will receive pre-appointment noticication letter'

sleep(5)
print 'step 11'
print 'schedule a group appointment in multiple time slot'
patients = client.service.SearchPatients(facility1_site_id,patient2_ssn)
patient2 = copy.deepcopy(client.service.GetPatient(patients[0]))

patients = client.service.SearchPatients(facility1_site_id,patient3_ssn)
patient3 = copy.deepcopy(client.service.GetPatient(patients[0]))


appointment2 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1

appointment2.Patient = patient2
appointment2.Length = 30
appointment2.Section = resource1.Section
appTimeStamp = datetime.datetime(2013,10,17,21,00,00)
appointment2.Time = appTimeStamp
appointment2.Resources = resourcearray
appointment2.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment2.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment2)
    appointment2_result = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment2_result.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient2.Id
comqueue.SendBy = datetime.datetime(2013,10,16)
comqueue.SentOn = datetime.datetime(2013,10,15)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment2_result

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

appointment3 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1
appointment3.Patient = patient3
appointment3.Length = 30
appointment3.Section = resource1.Section
appTimeStamp = datetime.datetime(2013,10,17,21,00,00)
appointment3.Time = appTimeStamp
appointment3.Resources = resourcearray
appointment3.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment3.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment3)
    appointment3_result = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment3_result.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient3.Id
comqueue.SendBy = datetime.datetime(2013,10,16)
comqueue.SentOn = datetime.datetime(2013,10,15)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment3_result

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

appTimeStamp = datetime.datetime(2013,10,17,21,30,00)
appointment2.Time = appTimeStamp
try:
    result = client.service.CreateAppointment(appointment2)
    appointment4_result = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment4_result.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient2.Id
comqueue.SendBy = datetime.datetime(2013,10,16)
comqueue.SentOn = datetime.datetime(2013,10,15)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment4_result

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

appTimeStamp = datetime.datetime(2013,10,17,21,30,00)
appointment3.Time = appTimeStamp
try:
    result = client.service.CreateAppointment(appointment3)
    appointment5_result = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment5_result.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient3.Id
comqueue.SendBy = datetime.datetime(2013,10,16)
comqueue.SentOn = datetime.datetime(2013,10,15)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment5_result

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 4'
if logdetail == 1:
	print appointment2_result
	print appointment3_result
	print appointment4_result
	print appointment5_result
print '\tgroup appointment is made in a multiple appointment time slot'

sleep(5)
print 'step 12'
print '\tschedule telehealth appointment'
patients = client.service.SearchPatients(facility1_site_id,patient4_ssn)
patient4 = copy.deepcopy(client.service.GetPatient(patients[0]))

appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1
appointment.Patient = patient4
appointment.Length = 30
appointment.Section = resource1.Section
appTimeStamp = datetime.datetime(2013,8,29,19,00,00)
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
appointment.TelehealthLocation = 'CA VA OUTPATIENT CLINIC'
try:
    result = client.service.CreateAppointment(appointment)
    appointment12 = copy.deepcopy(result)
    print appointment12.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()
	
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient4.Id
comqueue.SendBy = datetime.datetime(2013,8,25)
comqueue.SentOn = datetime.datetime(2013,8,24)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment12

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 5'
if logdetail == 1:
	print appointment12
print '\ttelehealth appointment is created'